#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.DlgOrderReportCriteria;
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	


	[TestFixture]
	public class BOL_OrderReport : BaseTest 
	{
		private BOL.OrderReport _tstOReport;
		private System.Guid _orderGuid;
		

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				DataRow drTemp = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 OrderedComponentGuid FROM OrderedComponent WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");

				_orderGuid = (System.Guid) drTemp[TABLES.OrderedComponent.OrderedComponentGuid];

				this.RefreshData = false;
			}

			_tstOReport = new BOL.OrderReport();
			_tstOReport.StartDate = System.DateTime.Now.AddYears(-1);
			_tstOReport.EndDate = System.DateTime.Now.AddYears(1);
			_tstOReport.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.Default);
		}	

		#region constructors

		[Test]
		public void Ctor_Pass()
		{
			BOL.OrderReport tmpOR = new BOL.OrderReport();

			Assert.IsNotNull(tmpOR);
			Assert.IsTrue(tmpOR.IsSingleOrderReport == false);
			Assert.IsTrue(tmpOR.SortByTreatingSpecialty);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Fail()
		{
		}

		#endregion


		#region properties

		[Test]
		public void RecordCount_Pass()
		{
			_tstOReport.IsSingleOrderReport = true;
			Assert.IsTrue(_tstOReport.RecordCount == 1);

			_tstOReport.IsSingleOrderReport = false;
			Assert.IsTrue(_tstOReport.RecordCount >= 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordCount_Fail()
		{
		}

		[Test]
		public void IsSingleOrderReport_Pass()
		{
			bool tstValue = (!this._tstOReport.IsSingleOrderReport);

			this._tstOReport.IsSingleOrderReport = tstValue;
			Assert.IsTrue(this._tstOReport.IsSingleOrderReport == tstValue);
		}

		[Test]
		public void IsSingleOrderReport_Fail()
		{
			this._tstOReport.OrderGuid = System.Guid.Empty;
			this._tstOReport.IsSingleOrderReport = true;
			Assert.IsTrue(this._tstOReport.IsRuleBroken(BROKEN.OrderGuid));
		}

		[Test]
		public void IsComponentOrder_Pass()
		{
			bool tstValue = (!this._tstOReport.IsComponentOrder);

			this._tstOReport.IsComponentOrder = tstValue;

			Assert.IsTrue(this._tstOReport.IsComponentOrder == tstValue);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IsComponentOrder_Fail()
		{
		}

		[Test]
		public void SortByTreatingSpecialty_Pass()
		{
			bool tstValue = (!this._tstOReport.SortByTreatingSpecialty);

			this._tstOReport.SortByTreatingSpecialty = tstValue;

			Assert.IsTrue(this._tstOReport.SortByTreatingSpecialty == tstValue);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void SortByTreatingSpecialty_Fail()
		{
		}

		[Test]
		public void OrderGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstOReport.OrderGuid = tstValue;

			Assert.IsTrue(this._tstOReport.OrderGuid == tstValue);
		}

		[Test]
		public void OrderGuid_Fail()
		{
			this._tstOReport.IsSingleOrderReport = true;
			this._tstOReport.OrderGuid = System.Guid.Empty;

			Assert.IsTrue(this._tstOReport.IsRuleBroken(BROKEN.OrderGuid));
		}

		[Test]
		public void SearchCriteria_Pass()
		{
			Assert.IsTrue(_tstOReport.SearchCriteria.Length > 0);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void SearchCriteria_Fail()
		{
		}

		#endregion


		#region methods

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void CreateReport_Pass()
		{
			//Report is xml, server cannot write to file.. Report would need manual verification
			this._tstOReport.IsSingleOrderReport = false;
			DataSet dsTest = this._tstOReport.CreateReport();
			Assert.IsNotNull(dsTest,"MultipleOrderReport");

			this._tstOReport.IsSingleOrderReport = true;
			this._tstOReport.IsComponentOrder = true;
			this._tstOReport.OrderGuid = this._orderGuid;

			dsTest = this._tstOReport.CreateReport();
			Assert.IsNotNull(dsTest,"SingleOrderReport");
		}


		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException)) ]
		public void CreateReport_Fail()
		{
			this._tstOReport.IsSingleOrderReport = true;
			this._tstOReport.OrderGuid = System.Guid.Empty;

			this._tstOReport.CreateReport();
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report to printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report to printer
		}

		#endregion
	}
}

#endif
